﻿
function AccessCodeOnchange(obj, codeLength) {
    var $errorMsgObj = $(obj).next('.error-message');
    $errorMsgObj.hide();
    var code = $(obj).val();
    if (code.length == 0) {
        $errorMsgObj.html("*Required");
        $errorMsgObj.show();
    }
    else {
        $(obj).val(code.toUpperCase());
        if (code.length > codeLength) {
            $(obj).val(code.toUpperCase().substr(0, codeLength));//超过长度就截取
        }
    }
}

function LoadCode(obj, codeLength) {
    var code = $(obj).val();
    if (code.length == codeLength && code != $("#loadedcode").val()) {
        //后台读取code, 如果设置了payamount, 自动加载到TotalPayAmount并且不可编辑
        $.ajax({
            type: 'GET',
            url: "/Home/LoadOnlinepaymentAccessCode",
            data: { "code": code },
            dataType: "json",
            beforeSend: function () {
                $("#divcover").show();
            },
            complete: function () {
                $("#divcover").hide();
            },
            success: function (data) {
                if (data.Pay > 0) {
                    $('#loadedcode').val(code);
                    $('#loadedcode').data('pay', data.Pay);
                    $('#TotalPayAmount').val(data.Pay);
                    $('#TotalPayAmount').attr('disabled', 'disabled');
                    $('#divPayAmountErr').hide();
                    $('#supTotalPay').hide();
                }
                else {
                    $('#TotalPayAmount').removeAttr('disabled');
                    //显示totalpay的*
                    $('#supTotalPay').show();
                }
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                debugger
                // 状态码
                console.log(XMLHttpRequest.status);
                // 状态
                console.log(XMLHttpRequest.readyState);
                // 错误信息
                console.log(textStatus);

            }
        });
    }
    else if (code != '' && code == $("#loadedcode").val()) {
        //加载过了
        $('#loadedcode').val(code);
        $('#TotalPayAmount').val($('#loadedcode').data('pay'));
        $('#TotalPayAmount').attr('disabled', 'disabled');
        $('#divPayAmountErr').hide();
        $('#supTotalPay').hide();
    }
    else {
        $('#loadedcode').val("");

        $('#TotalPayAmount').removeAttr('disabled');
        //显示totalpay的*
        $('#supTotalPay').show();
    }

}

function btnNext() {
    var flag = true;
    var $FirstName = $("#FirstName");
    var $LastName = $("#LastName");
    var $Email = $("#Email");
    var $ConfirmationId = $("#TourID");//客人输入的confirmationId
    var $AccessCode = $("#txtAccessCode");
    var $IsCheck = $("input[name=chkHaveAccessCode]").attr("checked");
    //var $TourCode = $("#TourCode");
    //var $PaymentType = $("input[name=radio-out-tpc]:checked");
    var $TotalPaidAmount = $("#TotalPayAmount");
    var i = 0;
    if ($IsCheck == "checked") {
        flag = ValidateAccessCode($AccessCode, 6);
        i = 1;
    }

    flag &= InputValidation($FirstName, 'First Name', 'letter');
    flag &= InputValidation($LastName, 'Last Name', 'letter');
    flag &= InputValidation($Email, 'Email', 'email');
    flag &= InputValidation($ConfirmationId, 'Booking', 'confirmationid');
    // flag &= InputValidationTourCode($TourCode, 'Tour Code', 'TourCode')
    flag &= InputValidation($TotalPaidAmount, 'PayAmount', 'decimal')
    if (flag) {
        var payment = {
            FirstName: $FirstName.val(),
            LastName: $LastName.val(),
            Email: $Email.val(),
            TourID: $ConfirmationId.val(),
            TourCode: '',
            PaymentType: '',
            AccessCode: $AccessCode.val(),
            TotalPaidAmount: $TotalPaidAmount.val()
        }

        //ajax提交后台验证 通过AccessCode验证输入的金额和规则是否匹配
        $.ajax({
            type: 'POST',
            url: "/Home/OnlinePaymentNext",
            data: {
                "paymentModel": payment,
                "isCheck": i
            },
            dataType: "json",
            success: function (data) {
                if (data.Success) {
                    sessionStorage.setItem("payment", JSON.stringify(payment));
                    var temp = "";
                    if (i == 1)
                        temp = "?code=" + $AccessCode.val();
                    location.href = "/Home/OnlinePayCredit" + temp;

                }
                else {
                    let $errorDiv = $("#divOnlinePaymentError");
                    $errorDiv.html(data.Message);
                    $errorDiv.show();
                    $('body, html').animate({
                        scrollTop: $("#divOnlinePaymentError").offset().top - 120
                    }, 500);
                    setTimeout(function () { $errorDiv.hide(); }, 10000);
                }
            }
        });

    } else {
        $("#ss").css('display', 'block');
        return false;
    }
}
function InputValidationTourCode(obj, msg, type) {
    var flag = true;
    var objValue = $(obj).val() != undefined ? trimAll($(obj).val()) : "";
    var $errMsg = $("#tourcodeMsg");

    if (msg != "Phone2" && (objValue == "" || objValue == "undefined" || objValue == null)) {
        $errMsg.html("* Required");
        $errMsg.show();
        flag = false;
    }
    //输入的 code  是 FITE/SPECE/FITC/SPECC 时直接通过走后台验证
    var key = (flag && (objValue == "FITE" || objValue == "SPECE" || objValue == "FITC" || objValue == "SPECC"));
    if (flag && !key) {
        $.ajax({
            type: 'POST',
            url: "/Home/IsTourCode",
            data: { tourcode: $("#TourCode").val() },
            async: false,
            success: function (res) {
                if (!Boolean(res)) {
                    $errMsg.html("* Code Not Exists");
                    $errMsg.show();
                    flag = false;
                }
            }
        })
    }
    if (flag) {
        $errMsg.hide();
        if (type != "") {
            flag = ValidataCommonInputValidationRule(type, obj, msg);
        }
    }
    return flag;
}
function InputValidationCardNumber(msg, type) {
    var flag = true;
    var objValue = $("#CreditCardNumber").val() != undefined ? trimAll($("#CreditCardNumber").val()) : "";
    var $errMsg = $("#cardnumberMsg");

    if (objValue == "" || objValue == "undefined" || objValue == null) {
        $errMsg.html("* Required");
        $errMsg.show();
        flag = false;
    }
    if (flag) {
        var masterCard = /^[5]\d{15}$/;
        var visaCard = /^[4]\d{15}$/;
        var CardType = $("input[name=radio-card-type]:checked").val();
        if (CardType == "Visa") {
            if (!visaCard.test(objValue)) {
                $errMsg.html("* Invalid card number");
                $errMsg.show();
                flag = false;
            }
        } else {
            if (!masterCard.test(objValue)) {
                $errMsg.html("* Invalid card number");
                $errMsg.show();
                flag = false;
            }
        }
    }
    if (flag) {
        $errMsg.hide();
        if (type != "") {
            flag = ValidataCommonInputValidationRule(type, $("#CreditCardNumber"), msg);
        }

    }
    return flag;
}

function btnCreditSubmit() {
    if ($("input[name=conditions]:checked").val()) {
        var key = true;
        var $CreditCardNumber = $("#CreditCardNumber");
        var $CardHolderName = $("#CardHolderName");
        var $FirstName = $("#FirstName");
        var $LastName = $("#LastName");
        var $Telephone = $("#Telephone");
        var $AddressLine1 = $("#AddressLine1");
        var $City = $("#City");
        var $ZipCode = $("#ZipCode");
        var $CCV = $("#CCV");
        key &= InputValidationCardNumber('CardNumber', 'cardNumber');
        if (!key) {
            ShowErrorMessage("<div>Please check credit card number and type.</div>");
            key &= false;
            return;
        }
        key &= InputValidation($CardHolderName, 'CardHolderName', 'CardHolders Name');
        key &= InputValidation($CCV, 'CVV', 'number');
        key &= InputValidation($Telephone, 'Phone', 'phone');
        key &= InputValidation($AddressLine1, 'Address', '');
        key &= InputValidation($City, 'City', 'letter');
        key &= InputValidation($ZipCode, 'Zip Code', 'zipCode');
        var ExpiryMonth = $("#ExpirationDateMM").val();
        if (ExpiryMonth == "") {
            ShowErrorMessage("Please select card expiry month.");
            key &= false;
            return;
        }
        var ExpiryYear = $("#ExpirationDateYYYY").val();
        if (ExpiryYear == "") {
            ShowErrorMessage("Please select card expiry year.");
            key &= false;
            return;
        }
        if (!IsCardActive(ExpiryYear, ExpiryMonth)) {
            ShowErrorMessage("Sorry, the credit card you selected is expired.");
            key &= false;
            return;
        }
        if (key) {
            var card = new Object();
            card.AdminCardHolderId = 0;
            card.fullCardNumber = $CreditCardNumber.val();
            card.cardHolderName = $CardHolderName.val();
            card.CardExpiration = $("#ExpirationDateYYYY").val() + "-" + $("#ExpirationDateMM").val() + "-01";
            card.CVV = $CCV.val();
            card.cardType = $("input[name=radio-card-type]:checked").val();
            card.FirstName = $FirstName.val();
            card.LastName = $LastName.val();

            var billingAddress = new Object();
            billingAddress.firstName = $FirstName.val();
            billingAddress.lastName = $LastName.val();
            billingAddress.addressLine1 = $AddressLine1.val();
            billingAddress.city = $City.val();
            billingAddress.state = $("#State").val();
            billingAddress.countryId = $("#CountryId").val();
            billingAddress.countryName = $("#CountryId").find("option:selected").data("countryname");
            billingAddress.zipcode = $ZipCode.val().trim();
            billingAddress.phone = $Telephone.val();

            if (billingAddress.firstName == "" || billingAddress.lastName == ""
                || billingAddress.addressLine1 == "" || billingAddress.city == "" || billingAddress.state == ""
                || billingAddress.countryId == "" || billingAddress.zipcode == "" || billingAddress.phone == "") {
                ShowErrorMessage("Please complete billing address.");
                return;
            }
            if (!ZipCodeCheck(billingAddress.zipcode, billingAddress.countryId)) {
                ShowErrorMessage("Please input the correct Zipcode.")
                return;
            }

            if (card.fullCardNumber == "" || card.fullCardNumber == undefined) {
                ShowErrorMessage("Please entery your debit/credit card number");
                return;
            }
            if (card.CVV == "" || card.CVV == undefined || card.CVV.length < 3 || card.CVV.length > 4 || isNaN(card.CVV)) {
                ShowErrorMessage("CVV code does not match the credit/debit card you entered.");
                return;
            }
            if (card.cardHolderName == "") {
                ShowErrorMessage("Please entery your debit/credit card holder name");
                return;
            }

            var OnlinePayments = {
                FirstName: $FirstName.val(),
                LastName: $LastName.val(),
                Email: $("#Email").val(),
                PaymentType: '',
                TourID: $("#TourID").val(),
                TotalPaidAmount: $("#TotalPaidAmount").val(),
                CardType: $("input[name=radio-card-type]:checked").val(),
                ExpirationDate: '' + $("#ExpirationDateMM").val() + '/' + $("#ExpirationDateYYYY").val(),
                CardHolderName: $CardHolderName.val(),
                CreditCardNumber: $CreditCardNumber.val(),
                TourCode: '',
                TransactionId: $("#TransactionId").val(),
                OnlineBillingAddresses: [{
                    FirstName: $FirstName.val(),
                    MiddleName: $("#MiddleName").val(),
                    LastName: $LastName.val(),
                    CountryId: $("#CountryId").val(),
                    AddressLine1: $AddressLine1.val(),
                    Telephone: $Telephone.val(),
                    City: $City.val(),
                    State: $("#State").val(),
                    ZipCode: $ZipCode.val(),
                    Gender: $("#Gender").val(),
                    Booking: $("#TourID").val(),
                    PaymentsId: $("#PaymentsId").val(),
                    TourCode: $("#TourCode").val()
                }]
            };
            var test = $("input[name=testchek]:checked").val();
            $.ajax({
                data: {
                    json: JSON.stringify(OnlinePayments),
                    cardjson: JSON.stringify(card),
                    billingjson: JSON.stringify(billingAddress),
                    accessCode: $('#hidAccessCode').val(),
                    test: test
                },
                type: "post",
                url: "/Home/OnlinePayConmit",
                beforeSend: function () {
                    $("#divcover").show();
                },
                complete: function () {
                    $("#divcover").hide();
                },
                success: function (res) {
                    if (Boolean(res.isSuccess) > 0) {
                        clear();
                        sessionStorage.removeItem("payment");
                        location.href = "/Home/OnlinePayConfrim";
                    } else {
                        ShowErrorMessage(res.Result);
                    }
                }
            });
        } else {
            $("#auto").css('display', 'block');
        }
    } else {
        $("#errormess").show();
        return false;
    }
}
function ShowErrorMessage(errorMessage) {
    $("html,body").animate({
        scrollTop: 0
    }, 500);
    $("div[name='error']").html(errorMessage);
    $("div[name='error']").show().delay(15000).slideUp();
}

function clear() {
    var allInput = document.body.getElementsByTagName("input");
    for (var i = 0; i < allInput.length; i++) {
        var item = allInput[i];
        if (item.type == "text") {
            item.value = "";
        }
    }
}
function KeyUpTrimAll(obj) {
    $(obj).val(trimAll($(obj).val()));
}
//判断卡是否在有效期内 有效期内返回true, 过期返回false
function IsCardActive(cardYear, cardMonth) {
    var nowtime = new Date();
    var year = nowtime.getFullYear();
    var month = nowtime.getMonth();
    if (cardYear < year) {
        return false;
    }
    else if (cardYear == year) {
        if (cardMonth < month + 1) {
            return false;
        }
    }
    return true;
}
function errorshow() {
    if ($("input[name=conditions]:checked").val()) {
        $("#errormess").hide();
    } else {
        $("#errormess").show();
    }
}
function GetState() {
    var url = "/Home/GetStateByCountryId";
    var data = { CountryId: $("#CountryId").val() }
    $.post(url, data, function (res) {
        $("#State option").remove();
        $("#StateLabel").hide();
        $.each(res, function (index, data) {
            $("#StateLabel").show();
            $("#State").append("<option value='" + data.StateCode + "'>" + data.StateName + "</option>");
        })

    })
}

//验证 数字和字母 空格 横杠
function Validate_ZipCode(e) {
    $(e).val($(e).val().replace(/[^a-zA-Z0-9\s\-]/g, ''));
}
function ZipCodeCheck(zipCode, countryId) {
    var s = /^[0-9]{5}$/;
    switch (countryId) {
        case "88253":
            s = /^[Kk]{1}[Yy]{1}[1-3]{1}[\-]{1}[0-9]{4}$/;
            break;
        case "88238":
            s = /^[a-zA-Z]{1}[0-9]{1}[a-zA-Z]{1}[0-9]{1}[a-zA-Z]{1}[0-9]{1}$/;
            break;
        case "88248":
        case "88250":
            s = /^[0-9]{5}$/;
            break;
        default:
            s = /^[0-9]{5}$/;
            break;
    }

    //if (countryId == "88253") {
    //    s = /^[Kk]{1}[Yy]{1}[1-3]{1}$/;
    //}
    //if (countryId == "88238") {
    //    s = /^[a-zA-Z]{1}[0-9]{1}[a-zA-Z]{1}[0-9]{1}[a-zA-Z]{1}[0-9]{1}$/;
    //}
    zipCode = zipCode.replace(/\s+/g, "");//zipcode去掉空格后做验证
    return s.test(zipCode);
}
function ZipcodeOnKeyUp(e, countryId) {
    var input = $(e).val();
    switch (countryId) {
        case "88253": //cayman islands
            //s = /^[Kk]{1}[Yy]{1}[1-3]{1}$/;
            if (input.length > 2) {
                switch (input.length) {
                    case 3:
                        var lastChar = input.substr(input.length - 1, 1);
                        if (isNaN(lastChar)) {
                            input = input.substr(0, input.length - 1);
                        }
                        input = input + "-";
                        break;
                    case 4:
                        break;
                    default:
                        //第5位起都是数字
                        var lastChar = input.substr(input.length - 1, 1);
                        if (isNaN(lastChar)) {
                            input = input.substr(0, input.length - 1);
                        }
                        if (input.length > 8) {
                            input = input.substr(0, 8);
                        }
                        break;
                }
                $(e).val(input);
            }
            else {
                $(e).val("KY");
            }
            break;
        case "88238": //canada
            //s = /^[a-zA-Z]{1}[0-9]{1}[a-zA-Z]{1}[0-9]{1}[a-zA-Z]{1}[0-9]{1}$/;
            if (input.length <= 0)
                break;
            if (input.length < 4) {
                //奇数位为字母
                //偶数位为数字
                var lastChar = input.substr(input.length - 1, 1);
                if (input.length % 2 == 0) {
                    if (isNaN(lastChar)) {
                        input = input.substr(0, input.length - 1);
                    }
                }
                else {
                    s = /[a-zA-Z]{1}/;
                    if (!s.test(lastChar)) {
                        input = input.substr(0, input.length - 1);
                    }
                }
            }
            if (input.length > 4) {
                //偶数位为字母
                //奇数位为数字
                var lastChar = input.substr(input.length - 1, 1);
                if (input.length % 2 != 0) {
                    if (isNaN(lastChar)) {
                        input = input.substr(0, input.length - 1);
                    }
                }
                else {
                    s = /[a-zA-Z]{1}/;
                    if (!s.test(lastChar)) {
                        input = input.substr(0, input.length - 1);
                    }
                }
            }
            if (input.length == 3) //输入到第三位时自动加空格
            {
                input = input + " ";
            }
            if (input.length > 7) {
                input = input.substr(0, 7);
            }
            $(e).val(input);
            break;
        default:
            //其他国家均为5位数字
            if (input.length <= 0)
                break;
            if (input.length > 5) {
                input = input.substr(0, 5);
            }
            input = input.replace(/[^0-9]/g, '');
            $(e).val(input);
            break;
    }
}


//验证access code 6位数
function ValidateAccessCode(obj, codeLength) {
    var $codetxt = $(obj);
    var $errorMsgObj = $(obj).next(".error-message");
    var code = $codetxt.val();
    var validation = true;
    if (code.length == 0) {
        validation = false;
        $errorMsgObj.html("*Required");
        $errorMsgObj.show();
    }
    else {
        if (code.length != codeLength) {
            validation = false;
        }
        if (!validation) {
            $errorMsgObj.html("Invalid access code.");
            $errorMsgObj.show();
        }
    }
    return validation;
}